/*
   main.c
   Jeff Ondich, 2 January 2026

   Some testing code for the "bases & bits" assignment.
*/

#include <stdio.h>
#include "bases-and-bits.h"

void print_usage_statement(char *program_name);

int main(int argc, char *argv[]) {
    // Make sure there's only one command-line argument.
    if (argc != 2) {
        print_usage_statement(argv[0]);
        return 1;
    }

    // Make sure the command-line argument is a decimal integer.
    int n;
    int matches = sscanf(argv[1], "%d", &n);
    if (matches != 1) {
        print_usage_statement(argv[0]);
        return 1;
    }

    // Do the work.
    printf("Base 2: ");
    print_integer(n, 2);
    putchar('\n');

    printf("Base 8: ");
    print_integer(n, 8);
    putchar('\n');

    printf("Base 10: ");
    print_integer(n, 10);
    putchar('\n');

    printf("Base 16: ");
    print_integer(n, 16);
    putchar('\n');

    printf("Number of 1 bits: %d\n", count_one_bits(n));

    // All done. Return 0 to indicate the program terminated without error.
    return 0;
}

void print_usage_statement(char *program_name) {
    fprintf(stderr, "Usage: %s decimal_integer\n", program_name);
    fprintf(stderr, "\nPrints a small report on the given integer. For example:\n\n");
    fprintf(stderr, "\t$ %s 27\n", program_name);
    fprintf(stderr, "\tBase 2: 0b00000000000000000000000000011011\n");
    fprintf(stderr, "\tBase 8: 033\n");
    fprintf(stderr, "\tBase 10: 27\n");
    fprintf(stderr, "\tBase 16: 0x1b\n");
    fprintf(stderr, "\tNumber of 1-bits: 4\n\n");
}

