/*
    bases-and-bits.h
    Jeff Ondich, 2 January 2026

    Function specifications for the "bases & bits" assignment.
*/

/*
   Prints to standard output the integer n in the given base. Only works
   if base is 2, 8, 10, or 16; otherwise, prints '?'.

   The printed output will include the conventional prefixes 0b (for base 2),
   0 (for base 8), and 0x (for base 16). No newline is printed--that, if
   desired, would be the responsibility of the calling code.
   
   Precondition: n >= 0, because we don't want to deal with negative ints yet.
*/
void print_integer(int n, int base);

/*
   Prints to standard output the full 32-bit binary representation of n.

   For example, if n == 5, print_integer_in_binary(n) should print

       00000000000000000000000000000101
   
   This function does not print a "0b" at the beginning or a "\n" at the end;
   printing those, if desired, would be the responsibility of the calling code.

   Precondition: n >= 0, because we don't want to deal with negative ints yet.

   NOTE: This implementation may use putchar, but no other library functions.
*/
void print_integer_in_binary(int n);

/*
   Returns the number of 1 bits in the binary representation of
   the unsigned integer n. The return value is thus an integer
   between 0 and 32, inclusive.

   For example, if n == 27, this function returns 4, because the
   32-bit binary represenation of 27 is
   
      00000000000000000000000000011011

   NOTE: Your implementation of this function must use no library functions.
*/
int count_one_bits(unsigned int n);

