<?php


/* Function to filter form input
   $ctype_function = ctype_function name for checking input (ex: 'ctype_alnum')
   $variable = index of $_POST variable to check (stores any error into corresponding $errors string)
   Because of the limitations of ctype-functions no spaces are allowed.
   This would be overcome with more powerful regular expressions
   but would require a reworking of this function and the calls to it.
*/
function filter_form_input($ctype_function, $variable)
{
	// Allow function to modify error codes
	global $errors;

	// Filter input
	if ($_POST[$variable])
	{
		if ($ctype_function($_POST[$variable]))
		{
			return $_POST[$variable];
		}
		else
		{
			// Must only contain characters specified by $ctype_function
			switch($ctype_function)
			{
				case 'ctype_alnum':
					$errors[$variable] = 'Must only contain alpha-numeric characters';
					break;
				case 'ctype_alpha':
					$errors[$variable] = 'Must only contain alphabetic characters';
					break;
				case 'ctype_digit':
					$errors[$variable] = 'Must only contain numeric characters';
					break;
				default:
					$errors[$variable] = 'Unspecified error';
					break;
			}
		}
	}
	else
	{
		$errors[$variable] = 'Cannot be blank';
	}
	return null;
}



// Initialize Error Codes
$errors['username'] = null;
$errors['password'] = null;
$errors['first_name'] = null;
$errors['last_name'] = null;
$errors['address'] = null;
$errors['city'] = null;
$errors['state'] = null;
$errors['zip'] = null;
$errors['phone'] = null;


// If any $_POST was set then form was submitted so validate and set errors if necessary
// If subject to a Cross-Site Request Forgery the input is still filtered
// this is just to avoid printing errors when first visiting the form for a legit user
if (isset($_POST['username']))
{
	$username = filter_form_input('ctype_alnum', 'username');
	$password = filter_form_input('ctype_alnum', 'password');
	$first_name = filter_form_input('ctype_alpha', 'first_name');
	$last_name = filter_form_input('ctype_alpha', 'last_name');
	$address = filter_form_input('ctype_alnum', 'address');
	$city = filter_form_input('ctype_alpha', 'city');
	$state = filter_form_input('ctype_alpha', 'state');
	$zip = filter_form_input('ctype_digit', 'zip');
	$phone = filter_form_input('ctype_digit', 'phone');

	// Set $username to lower so it is case insensitive (stored as lowercase in database)
	$username = strtolower($username);

	// Ensure username is not already in use (if no other username error)
	if (!isset($errors['username']))
	{
		$file = "database.txt";
		$file_handle = fopen($file, 'r') or die("Can't open file");
		while ($line = fgets($file_handle))
		{
			$array = explode(':', $line);
			if ($array[0] === $username)
			{
				$errors['username'] = 'Username already in use';
				break;
			}
		}
		fclose($file_handle);
	}
}


// If any errors are set or a $_POST is not set (form not submitted), display signup form
if (isset($errors['username']) ||
	isset($errors['password']) ||
	isset($errors['first_name']) ||
	isset($errors['last_name']) ||
	isset($errors['address']) ||
	isset($errors['city']) ||
	isset($errors['state']) ||
	isset($errors['zip']) ||
	isset($errors['phone']) ||
	!isset($_POST['username']))
{
	// Display Signup Page
	$title = 'Signup';
	include 'header.inc';
	include 'signup.inc';
	include 'footer.inc';
}
// Otherwise all input checks out
else
{
	// Encrypt password (taken from Essential PHP Security (page 98)
	$salt = 'K3y';
	$encrypted_password = md5($salt . md5($password . $salt));

	// Process new user
	$file = "database.txt";
	$file_handle = fopen($file, 'a') or die("Can't open file");
	$output = "$username:$encrypted_password:$first_name:$last_name:$address:$city:$state:$zip:$phone\n";
	fwrite($file_handle, $output);
	fclose($file_handle);

	// Display successful signup page (consider user as already logged in)
	session_start();
	$_SESSION['logged_in'] = true;
	$_SESSION['username'] = $username;
	$title = 'Welcome';
	include 'header.inc';
	echo "Thank you $username for signing up.  Click <A HREF=\"week6_display.php\">here</A> to view your record.";
	include 'footer.inc';
}


?>
